IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_PRECIFICACAO_META_MARGEM_VALORES]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_PRECIFICACAO_META_MARGEM_VALORES]
GO  
--SELECT * FROM UFD_EST_PROD_PRECIFICACAO_META_MARGEM_VALORES (1,2,7)
CREATE FUNCTION [dbo].[UFD_EST_PROD_PRECIFICACAO_META_MARGEM_VALORES]  (@CD_EMP  INT,      
																		@CD_GRUPO INT,  
																		@CD_PROD INT)  
RETURNS @RS_TAB_COMIS TABLE ( TP_NIVEL					INT,  
							  PERC_MARGEM				MONEY,   
							  CD_PROD					INT,  
							  CD_GRUPO					INT,  
							  CD_EMP					INT)  
WITH ENCRYPTION AS                
BEGIN                
          

DECLARE @RS_DADOS_TBL_PARAM AS TABLE (CD_GRUPO		INT,
									  TP_NIVEL		INT, 
									  PERC_MARGEM	MONEY)  

 -------------------------------------------------------------------------------------------------------------------------------      
 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------      
 DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,      
          CD_PROD   INT,      
          CD_ARV_MERC_CATEG INT,      
          CD_ARV_MERC_SEG INT,      
          CD_ARV_MERC_PAPEL INT,      
          CD_ARV_MERC_MIX INT,      
          CD_ARV_MERC_CONSUMO INT,      
          CD_ARV_MERC_LINHA INT,      
          CD_ARV_MERC_MTZ_BCG INT,      
          CD_MC   INT,      
          CD_ARV_MERC_FAMILIA INT,              
          CD_APRES   INT,          
          CD_ARV_MERC_EQUI INT,      
          CD_GRP_EXPO  INT,      
          CD_FABRIC   INT)      
            
 -------------------------------------------------------------------------------------------------------------------------------      
 --BUSCANDO ARVORE MERC. DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------       
	INSERT INTO @EST_PROD_ARV_MERC      
	SELECT       
		ARV.CD_EMP     ,      
		ARV.CD_PROD     ,      
		ARV.CD_ARV_MERC_CATEG  ,      
		ARV.CD_ARV_MERC_SEG   ,      
		ARV.CD_ARV_MERC_PAPEL  ,      
		ARV.CD_ARV_MERC_MIX   ,      
		ARV.CD_ARV_MERC_CONSUMO  ,      
		ARV.CD_ARV_MERC_LINHA  ,      
		ARV.CD_ARV_MERC_MTZ_BCG  ,      
		ARV.CD_MC     ,      
		ARV.CD_ARV_MERC_FAMILIA  ,              
		ARV.CD_APRES    ,          
		ARV.CD_ARV_MERC_EQUI  ,      
		ARV.CD_GRP_EXPO    ,      
		P.CD_FABRIC       
	FROM 
		EST_PROD_EST_ARV_MERCADOLOGICA ARV 
		INNER JOIN EST_PROD P ON      
		ARV.CD_EMP  = P.CD_EMP      
		AND ARV.CD_PROD = P.CD_PROD      
	WHERE   
		P.CD_EMP = @CD_EMP       
		AND P.CD_PROD = @CD_PROD;
           
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 1 - PRODUTOS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		1 AS TIPO_NIVEL,	     
		B.PERC_MARGEM
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_PROD B INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_PROD = ARV.CD_PROD             
	WHERE       
		B.CD_GRUPO = @CD_GRUPO      
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_GRUPO = B.CD_GRUPO)      
   ORDER BY 
		B.DT_CAD DESC, 
		B.PERC_MARGEM asc  
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 2 - FAMLIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		2 AS TIPO_NIVEL,	     
		B.PERC_MARGEM    
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_ARV_MERC_FAMILIA B       
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA      
	WHERE       
		B.CD_GRUPO = @CD_GRUPO         
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO 
					FROM 
						@RS_DADOS_TBL_PARAM T 
					WHERE 
						T.CD_GRUPO = B.CD_GRUPO)      
		ORDER BY 
			B.DT_CAD DESC, 
			B.PERC_MARGEM DESC     
          
 -------------------------------------------------------------------------------------------------------------------------------          
 --Consultando as tbls de COMISSO no NVEL 3 - MARCAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		3 AS TIPO_NIVEL,	     
		B.PERC_MARGEM      
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_MC B 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_MC = ARV.CD_MC              
	WHERE       
		B.CD_GRUPO = @CD_GRUPO 
		AND NOT EXISTS (SELECT T.CD_GRUPO 
							FROM @RS_DADOS_TBL_PARAM T 
							WHERE T.CD_GRUPO = B.CD_GRUPO)      
	ORDER BY 
		B.DT_CAD DESC, 
		B.PERC_MARGEM DESC;
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 4 - FABRICANTES      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		4 AS TIPO_NIVEL,	     
		B.PERC_MARGEM        
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_PROD_FABRIC B 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_FABRIC = ARV.CD_FABRIC               
	WHERE       
		B.CD_GRUPO = @CD_GRUPO 
		AND NOT EXISTS (SELECT 
							T.CD_GRUPO 
						FROM 
							@RS_DADOS_TBL_PARAM T 
						WHERE T.CD_GRUPO = B.CD_GRUPO)      
	ORDER BY 
		B.DT_CAD DESC, 
		B.PERC_MARGEM DESC;

-------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 5 - CATEGORIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		5 AS TIPO_NIVEL,	     
		B.PERC_MARGEM      
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_ARV_MERC_CATEGORIA B 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG      
	WHERE       
		B.CD_GRUPO = @CD_GRUPO AND         
		NOT EXISTS (SELECT 
					T.CD_GRUPO 
					FROM 
					@RS_DADOS_TBL_PARAM T 
					WHERE 
					T.CD_GRUPO = B.CD_GRUPO)      
	ORDER BY 
		B.DT_CAD DESC, 
		B.PERC_MARGEM DESC;
		
 ----------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 6 - LINHAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		B.CD_GRUPO, 
		6 AS TIPO_NIVEL,	     
		B.PERC_MARGEM
	FROM 
		EST_PROD_PRECIFICACAO_META_MARGEM_EST_ARV_MERC_LINHA B 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND         
		B.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA      
	WHERE       
		B.CD_GRUPO = @CD_GRUPO AND       
		NOT EXISTS (SELECT 
					T.CD_GRUPO 
					FROM 
					@RS_DADOS_TBL_PARAM T 
					WHERE 
					T.CD_GRUPO = B.CD_GRUPO)      
	ORDER BY 
		B.DT_CAD DESC, 
		B.PERC_MARGEM ASC;

    
	INSERT INTO @RS_TAB_COMIS   
	SELECT TOP 1		
		TP_NIVEL,
		PERC_MARGEM,   
		@CD_PROD AS CD_PROD,  
		@CD_GRUPO AS CD_GRUPO,  
		@CD_EMP AS CD_EMP  
	FROM 
		@RS_DADOS_TBL_PARAM A  
	ORDER BY 
		TP_NIVEL ASC, 
		PERC_MARGEM ASC  
  
RETURN  
  
END        
  